(function ( $ ) { 
    $.fn.jQuerySimpleCounter = function( options ) {
      var settings = $.extend({
        start:  0,
        end:    100,
        easing: 'swing',
        duration: 400,
        complete: ''
      }, options );

      var thisElement = $(this);  

      $({count: settings.start}).animate({count: settings.end}, {
        duration: settings.duration,
        easing: settings.easing,
        step: function() {
          var mathCount = Math.ceil(this.count);
          thisElement.text(mathCount);
        },
        complete: function(){
          thisElement.text(settings.end);
        }
      });
    };
  }( jQuery ));
